library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
-- Whlt anhand des Select-Signals einen von vier 5-Bit Eingngen und latcht diesen auf einen 5-Bit Ausgang 
-- Sel=0001:In(9..5) wird gelatcht, Sel=0010:In(14..10) wird gelatcht, Sel=0100:In(19..15) wird gelatcht, Sel=1000:In(4..0) wird gelatcht, 
-- Latch-Signal kommt vor Sel-Update, deswegen latcht Sel=0001 den Eingangsblock 2 und nicht Eingangsblock 1
-- Sel=0001 + Latch -> Latcht Block2 und gleich danach wird Sel=0010 -> D.h. Latch Block ist gleich Sel-Anzeige

entity Mux20_5Latch is
    Port ( Sel   	: in	STD_LOGIC_VECTOR (3 downto 0);							--Select-Signal
			  Latch	: in  STD_LOGIC;														--Latch-Signal
			  DIn  	: in	STD_LOGIC_VECTOR (19 downto 0);							--Eingangsvektor 4x5 Bit
           DOut 	: out STD_LOGIC_VECTOR (4 downto 0) := (others => '0')	--Ausgangsvektor 5 Bit
		  );
end Mux20_5Latch;


architecture Behavioral of Mux20_5Latch is
signal zw : STD_LOGIC_VECTOR (4 downto 0);

begin
	-- 20 zu 5 Multiplexer
	process (Sel, DIn)
	begin
		case Sel is
			when "0001" => zw(4 downto 0) <= DIn(9 downto 5);	      
			when "0010" => zw(4 downto 0) <= DIn(14 downto 10);		   
			when "0100" => zw(4 downto 0) <= DIn(19 downto 15);    	
			when others => zw(4 downto 0) <= DIn(4 downto 0);		
		end case;
	end process;	
	
	-- 5-Bit Latch	
	process (Latch, zw)	
	begin
		if rising_edge(Latch) then						--Bei steigender Flanke: 
			DOut(4 downto 0) <= zw(4 downto 0); 	--MUX-Selektion wird nach Ausgang gelatcht
		end if;
	end process;					
	
end Behavioral;
