library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
-- 19-Bit Seriell-Parallel Schieberegister.

entity SR19 is
	Port ( DOut : out  	STD_LOGIC_VECTOR (18 downto 0) := (others => '0');	--19-Bit Ausgang des Schieberegisters
          Clk 	: in  	STD_LOGIC;														--Eingangs-Clock
          DIn 	: in  	STD_LOGIC														--Eingangs-Datenbit
			);
end SR19;


architecture Behavioral of SR19 is
	signal zw 	: 		STD_LOGIC_VECTOR (18 downto 0) := (others => '0');

begin
	---------- Das 19-Bit Schieberegister
	Sreg19: process (Clk)	
	begin
		if rising_edge(Clk) then				--Bei steigender Flanke: 
			for i in 0 to 17 loop 			   --Bit(0..17) jeweils eins nach unten schieben
				zw(i) <= zw(i+1);
			end loop;
			zw(18) <= DIn; 						--Bit18 mit Eingangsbit fllen
		end if;
	end process;
	
	DOut(18 downto 0) <= zw(18 downto 0);	
end Behavioral;
