library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
-- Dekodiert einen 4-Bit Eingang zu einem 7-Segment Ausgang 

entity Dec4_7Seg is
    Port ( DIn  : in	STD_LOGIC_VECTOR (3 downto 0);							--4-Bit Eingang
           DOut : out STD_LOGIC_VECTOR (6 downto 0) := (others => '0')	--7Bit Ausgang zu 7-Segment-Anzeige
		  );
end Dec4_7Seg;


architecture Behavioral of Dec4_7Seg is

begin
	-- 4Bit zu 7Segment Decoder
	process (DIn)
	begin
		case DIn is
			--7-Segment Kodierung GFEDCBA(1:Segment leuchtet, 0:Segment ist dunkel)
			when "0000" => Dout(6 downto 0) <= "0111111";		--"0"
			when "0001" => Dout(6 downto 0) <= "0000110";		--"1"
			when "0010" => Dout(6 downto 0) <= "1011011";		--"2"
			when "0011" => Dout(6 downto 0) <= "1001111";		--"3"
			when "0100" => Dout(6 downto 0) <= "1100110";		--"4"
			when "0101" => Dout(6 downto 0) <= "1101101";		--"5"
			when "0110" => Dout(6 downto 0) <= "1111101";		--"6"
			when "0111" => Dout(6 downto 0) <= "0000111";		--"7"
			when "1000" => Dout(6 downto 0) <= "1111111";		--"8"
			when "1001" => Dout(6 downto 0) <= "1101111";		--"9"
			when "1010" => Dout(6 downto 0) <= "1100000";		--Ziel eingeklappt
			when "1011" => Dout(6 downto 0) <= "0110000";		--Ziel ausgeklappt
			when "1100" => Dout(6 downto 0) <= "1000000";		--"-"
			when others => Dout(6 downto 0) <= "0000000";
		end case;
	end process;					
	
end Behavioral;





