library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
-- Sendet ein Latch-Signal und zhlt dann eine '1' im Kreis durch 4 Register, 
-- wenn einer von zwei Steuereingngen '1' und der andere rising edge ist

entity RCnt4 is
	Port ( DOut 	: out  	STD_LOGIC_VECTOR (3 downto 0) := (others => '0');	--4-Bit Ausgang des Ringcounters
			 LOut		: out 	STD_LOGIC;														--Latch-Ausgang
			 Gate1	: in  	STD_LOGIC;														--Eingangs-Gate/Clock 1
          Gate2 	: in  	STD_LOGIC														--Eingangs-Gate/Clock 2
			);
end RCnt4;


architecture Behavioral of RCnt4 is
signal zw : STD_LOGIC;
signal zout : STD_LOGIC_VECTOR (3 downto 0);

begin
	process (zw)	
	begin
		if rising_edge(zw) then					--Bei steigender Flanke des kombinierten Gate-Signals 
			case zout(3 downto 0) is
				when "0001" => zout(3 downto 0) <= "0010";
				when "0010" => zout(3 downto 0) <= "0100";
				when "0100" => zout(3 downto 0) <= "1000";
				when "1000" => zout(3 downto 0) <= "0001";
				when others => zout(3 downto 0) <= "0001";
			end case;
		end if;
	end process;

	zw <= Gate1 and Gate2;							--Erzeugt steigende Flanke, wenn entweder Gate1='1' und Gate2=rising edge oder anders herum
	Dout(3 downto 0) <= zout(3 downto 0); 
	LOut <= zw;

end Behavioral;
