library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
--bernimmt ber Schieberegister einen 4Bit-Codes und drei 5Bit-Codes und decodiert und schaltet einen davon auf den 7-Segment-Anzeige-Ausgang
--ber eine externe Ziffern-Clock wird durch alle 4Codes/Ziffern durchgeschaltet und ein entsprechender Ziffern-Ausgang aktiv gesetzt
--Ziffern 3,2,1 beinhalten ber extra-Bit den Zustand des Dezimalpunktes der 7-Segmentanzeige, Ziffer 0 hat dies nicht, da der Dezimalpunkt der rechtesten Ziffer nie angezeigt werden msste
--bernimmt als weiteren Wert den Zustand der Status-LED
--Die Ziffern/Codes sind folgendermaen definiert:
--Ziffer3=linkeste 7-Segment-Anzeige / Ziffer0=rechteste 7-Segment-Anzeige
--Code3 ist der BCD-Code der Ziffer3 / Code0 ist der BCD-Code der Ziffer0
--Code0 (4Bit): BCD3-BCD2-BCD1-BCD0 / Codes 1,2,3 (5Bit): BCD3-BCD2-BCD1-BCD0-DP (DP=Dezimalpunkt)
--Erwartete zeitliche Reihenfolge des Eingangs-Bitstroms:
--Code0(0)-Code0(1)-Code0(2)-Code0(3)-Code1(DP)-Code1(0)-Code1(2)-...-Code3(DP)-Code3(0)-Code3(1)-Code3(2)-Code3(3)
--Whrend der Seriell-bertragung ist InSBsy='0', auerhalb einer bertragung ist InSBsy='1'
--Bei risingedge von InSBsy wird der Zustand der Status-LED von InSDat bernommen
--Ein Ziffern-Selektor, whlt schaltet reihum eine der 4 Ziffern auf den Segment-Ausgang und gibt ein entsprechendes Ziffer-Select-Signal aus
--OutSeg=Ziffer3:OutZif="1000" / OutSeg=Ziffer2:OutZif="0100" / OutSeg=Ziffer1:OutZif="0010" / OutSeg=Ziffer0:OutZif="0001"

entity TopModel is
    Port ( 	InSClk : in  	STD_LOGIC;									-- Schieberegister-Clock
				InSDat : in  	STD_LOGIC;									-- Schieberegister-Data
				InSBsy : in		STD_LOGIC;									-- Schieberegister-Busy (=0 wenn SR-Datentransfer aktiv)
				InZClk : in  	STD_LOGIC;									-- Ziffern-Clock zum Durchschalten durch die 4 Ziffern
				OutZif : out	STD_LOGIC_VECTOR (3 downto 0);		-- Ausgang zu den Ziffern-Selects
				OutSeg : out  	STD_LOGIC_VECTOR (6 downto 0);		-- Ausgang zu den Ziffern-Segmenten
				OutPkt : out  	STD_LOGIC;									-- Ausgang zu den Dezimalpunkten der 7-Segment-Anzeigen
				OutLED : out  	STD_LOGIC									-- Ausgang zur Status-LED
			);
end TopModel;

architecture Structure of TopModel is
signal srcode 	:  STD_LOGIC_VECTOR (18 downto 0);	--Der Ausgangscode des Schieberegisters
signal lcode 	:  STD_LOGIC_VECTOR (4 downto 0);	--Der Ausgang der Code-Latches
signal zsel		:	STD_LOGIC_VECTOR (3 downto 0);	--Der Ziffern-Selektor
signal zlat		:	STD_LOGIC;								--Der Ziffern-Latch

component SR19 is
	Port ( DOut : out  	STD_LOGIC_VECTOR (18 downto 0) := (others => '0');	--19-Bit Ausgang des Schieberegisters
          Clk 	: in  	STD_LOGIC;														--Eingangs-Clock
          DIn 	: in  	STD_LOGIC														--Eingangs-Datenbit
			);
end component SR19;

component Mux20_5Latch is
    Port ( Sel   	: in	STD_LOGIC_VECTOR (3 downto 0);							--Select-Signal
			  Latch	: in  STD_LOGIC;														--Latch-Signal
			  DIn  	: in	STD_LOGIC_VECTOR (19 downto 0);							--Eingangsvektor 4x5 Bit
           DOut 	: out STD_LOGIC_VECTOR (4 downto 0) := (others => '0')	--Ausgangsvektor 5 Bit
		  );
end component Mux20_5Latch;

component Dec4_7Seg is
    Port ( DIn  : in	STD_LOGIC_VECTOR (3 downto 0);							--4-Bit Eingang
           DOut : out STD_LOGIC_VECTOR (6 downto 0) := (others => '0')	--7Bit Ausgang zu 7-Segment-Anzeige
		  );
end component Dec4_7Seg;

component RCnt4 is
	Port ( DOut 	: out  	STD_LOGIC_VECTOR (3 downto 0) := (others => '0');	--4-Bit Ausgang des Ringcounters
			 LOut		: out 	STD_LOGIC;														--Latch-Ausgang
			 Gate1	: in  	STD_LOGIC;														--Eingangs-Gate/Clock 1
          Gate2 	: in  	STD_LOGIC														--Eingangs-Gate/Clock 2
			);
end component RCnt4;

component Latch1 is
    Port ( DIn  : in		STD_LOGIC;					--Eingangs-Datenbit
			  DOut : out	STD_LOGIC;					--Gelatchter Ausgang
			  Clk	 : in  	STD_LOGIC					--Latch-Clock
		  );
end component Latch1;



begin

--bernimmt 19 Bit von Din bei jeweils steigender Clk
ShiftReg: SR19
port map (	DOut(18 downto 0) => srcode(18 downto 0),
				Clk => InSClk,
				DIn => InSDat);
					
--Latcht einen von 4 Codes abhnging von Sel auf den Ausgang, bei Code0 wird eine '0' statt dem entsprechenden DP-Bits gelatcht (Ziffer0 hat keinen Dezimalpunkt)					
MuxLat: Mux20_5Latch
port map (	Sel(3 downto 0) => zsel(3 downto 0),
				Latch => zlat,
				DIn(19 downto 1) => srcode(18 downto 0),
				Din(0) => '0',											--Der Dezimalpunkt der Ziffer 0 ist deaktiviert
				DOut(4 downto 0) => lcode(4 downto 0));
		
--Decodiert den Segment-Bereich eines Codes (Bit 4..1) zu einer 7-Segment-Anzeige (Bit0 des Codes ist der Dezimalpunkt)		
Dec4_7: Dec4_7Seg
port map (	DIn(3 downto 0) => lcode(4 downto 1), 			--lcode(0) ist Zustand des Dezimalpunkts
				DOut(6 downto 0) => OutSeg(6 downto 0));	

--Schaltet durch die Ziffern	(angetrieben von externer InZClk)	
--Grund fr die zwei Gates/Clocks: Der Latch vom ShiftReg in das MuxLat soll nur geschehen, wenn das Schieberegister
--gerade nicht geladen wird, ansonsten warten bis die Ladung des ShiftReg beendet ist - damit kein unsinniger Zwischenwert
--gelatcht wird.
--Latch-Option1: InZClk=rise und InSBsy=1 (Latch wenn ShiftReg gerade nicht aktiv): InZClk treibt Latch-Rise
--Latch-Option2: InZClk=rise und InSBsy=0 (Latch wenn ShiftReg gerade aktiv): InSBsy treibt Latch-Rise, wenn ShiftReg-Ladung beendet (InSBsy=rise whrend InZClk="1")		
ZSelect: RCnt4
port map (	DOut(3 downto 0) => zsel(3 downto 0), 
				LOut => zlat,		
				Gate1 => InZClk,
				Gate2 => InSBsy);

--Latcht den Zustand der Status-LED vom InSDat bei Ende der Seriell-bertragung (InSBsy rising edge)
LEDLat: Latch1
port map (	DIn  => InSDat,		
				DOut => OutLED,
				Clk => InSBsy);


--Stndige Verbindungen
OutPkt <= lcode(0);								--Ausgabe des Dezimalpunkts einer Ziffer						
OutZif(3 downto 0) <= zsel(3 downto 0);	--Ausgabe der Ziffern-Selects				
									 
end Structure;

