Option Strict Off
Option Explicit On
Public Class Mainform
    Inherits System.Windows.Forms.Form

    Public weiter As Boolean

    Private Sub Command1_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command1.Click
        weiter = True
    End Sub

    Private Sub Mainform_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
        SerialPort.DtrEnable = False    '-12V enablen
        SerialPort.RtsEnable = True     '+12V enablen
        SerialPort.PortName = "COM1"
        SerialPort.BaudRate = 110
        SerialPort.Parity = IO.Ports.Parity.None
        SerialPort.DataBits = 8
        SerialPort.StopBits = IO.Ports.StopBits.One
        SerialPort.ReceivedBytesThreshold = 2   'Event nach 2 empfangenen Bytes ausloesen
        SerialPort.Open()

        Label2.Visible = True
        Command1.Visible = True
        Label1.Visible = False
        Label3.Visible = False
        Label4.Visible = False
        Label5.Visible = False
        Label6.Visible = False
        Label7.Visible = False
        weiter = False
        Me.Show()

        While weiter = False 'Warte auf OK-Druck
            System.Windows.Forms.Application.DoEvents()
        End While

        Label2.Visible = False
        Command1.Visible = False
        Label7.Visible = True
        Timer1.Enabled = True       'Timer sendet regelmaessig Messaufforderung an HW, HW-Antwort triggert Update der Anzeige
    End Sub

    Private Sub SerialPort_DataReceived(ByVal sender As Object, ByVal e As System.IO.Ports.SerialDataReceivedEventArgs) Handles SerialPort.DataReceived
        Dim vv As Single
        Dim vb As Single
        Dim rec(1) As Byte

        SerialPort.Read(rec, 0, 2)      '2 Antwort-Bytes empfangen
        If rec(0) > rec(1) Then
            vv = System.Math.Round(rec(1) * 13.44 / 256 - 0.28, 2)
            vb = System.Math.Round(rec(0) * 13.08 / 256 - 0.33, 2)
        Else
            vv = System.Math.Round(rec(0) * 13.08 / 256 - 0.33, 2)
            vb = System.Math.Round(rec(1) * 13.44 / 256 - 0.28, 2)
        End If
        Anzeigeupdate(vb, vv)   'Anzeigeupdate muss ber Invoked Delegate Sub ablaufen, da SerialPort.DataReceived als eigener Thread laeuft!
    End Sub

    Private Delegate Sub AnzeigeupdateDelegate(ByVal vb As Single, ByVal vv As Single)
    Private Sub Anzeigeupdate(ByVal vb As Single, ByVal vv As Single)
        If Me.InvokeRequired Then
            Me.Invoke(New AnzeigeupdateDelegate(AddressOf Anzeigeupdate), vb, vv)
        Else
            If vb > 9 And vv > 9 Then
                Label7.Text = "Keine gueltige Messung"
                Label3.Visible = False
                Label4.Visible = False
                Label5.Visible = False
                Label6.Visible = False
            ElseIf vb > 9 Then
                Label7.Text = "Standarddiode"
                Label5.Text = Str(vv)
                Label3.Visible = True
                Label4.Visible = False
                Label5.Visible = True
                Label6.Visible = False
            Else
                Label7.Text = "Zenerdiode"
                Label5.Text = Str(vv)
                Label6.Text = Str(vb)
                Label3.Visible = True
                Label4.Visible = True
                Label5.Visible = True
                Label6.Visible = True
            End If
        End If
    End Sub

    Private Sub Mainform_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
        Timer1.Enabled = False
        Label1.Visible = True
        Command1.Visible = True
        Label2.Visible = False
        Label3.Visible = False
        Label4.Visible = False
        Label5.Visible = False
        Label6.Visible = False
        Label7.Visible = False

        weiter = False
        While weiter = False 'Warte auf OK-Druck
            System.Windows.Forms.Application.DoEvents()
        End While

        SerialPort.Close()
    End Sub

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        SerialPort.Write(Chr(85))   'Sendbyte=01010101 Signal zur Neumessung
    End Sub


End Class