Option Strict Off
Option Explicit On
Imports System.IO
Imports System.IO.Ports
Imports System.Text
Imports MSCommLib
Friend Class Mainform
    Inherits System.Windows.Forms.Form
    Dim WithEvents MSComm1 As New MSComm
    Dim connected As Boolean
    Dim startzeit As Date
    Dim dirstring As String
    Dim timefstart As Long
    Dim formatbyte As Byte
    Dim firstbyte As Boolean
    Dim frame() As Byte
    Dim frameindex As Byte

    'Funktionen der bergeordneten Anwendung
    Private Sub Form1_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
        Me.Show()
        FillCOMPortList()
        B_Connect.Text = "Connect"
        connected = False
        firstbyte = True
    End Sub

    Private Sub FillCOMPortList()
        Dim ports As String() = SerialPort.GetPortNames()
        Dim port As String

        For Each port In ports                  'Alle COM-Ports einfuegen
            ComboCOMPorts.Items.Add(port)
        Next port
        If ComboCOMPorts.Items.Count > 0 Then
            ComboCOMPorts.SelectedIndex = 0
            B_Connect.Enabled = True
        End If
    End Sub

    Private Sub B_Save_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles B_Save.Click
        'Sichert das Messergebnis je nach gewhltem Tab in ein File ab

        'Schreibt aktuelle Daten aus T_Snif_Protokoll-Textbox in ein csv-File (von unten nach oben und ersetzt ":" durch ";"
        Dim Myfile As String = ""
        Dim n As Integer
        Dim line As String

        With SaveFileDialog
            .Filter = "CSV Files (*.csv)|*.csv"
            .FilterIndex = 1
            '.InitialDirectory = OpStrings(1)
            .Title = "Daten in File speichern"
            .FileName = ""
        End With
        If SaveFileDialog.ShowDialog() = DialogResult.OK Then
            Myfile = SaveFileDialog.FileName
            Dim quelle As New FileStream(Myfile, FileMode.Create)
            Dim writer As New StreamWriter(quelle)
            writer.BaseStream.Seek(0, SeekOrigin.Begin)     ' Pointer auf file-Anfang
            writer.WriteLine("K-Line Sniffer Messprotokoll")
            For n = 0 To T_Snif_Protokoll.Lines.Length - 1
                line = T_Snif_Protokoll.Lines(T_Snif_Protokoll.Lines.Length - 1 - n)    'Von unten nach oben schreiben, da Protokoll immer oben hinzugefgt wurde
                line = line.Replace(":", ";")
                writer.WriteLine(line)
            Next
            writer.Close()
            quelle.Close()
        End If
    End Sub

    Private Sub B_Connect_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles B_Connect.Click
        If B_Connect.Text = "Connect" Then
            ComboCOMPorts.Enabled = False
            GroupBox1.Enabled = False
            B_Connect.Text = "Disconnect"
            With MSComm1
                .CommPort = Val(Mid(ComboCOMPorts.SelectedItem, 4))
                .Settings = "19200,S,8,1"   '8 Datenbits, als 9. Bit wird Parity "Space"(=0) erwartet. Wenn 9.Bit =1 ist, wird comEventRxParity-Event ausgelst
                .ParityReplace = ""         'Bei Parity-Error soll das empfangene Byte nicht durch ein Fehlerzeichen (normal 0x3F/"?") ersetzt werden
                .RThreshold = 1             'OnComm-Event wird ausgeloest wenn soviele Bytes angekommen sind
                .InputLen = 1               'Input liest 1 Byte
                .PortOpen = True
            End With
            connected = True
            startzeit = DateTime.UtcNow
            T_Snif_Protokoll.Clear()
        Else
            ComboCOMPorts.Enabled = True
            GroupBox1.Enabled = True
            B_Connect.Text = "Connect"
            MSComm1.PortOpen = False
            connected = False
        End If
    End Sub

    Private Sub B_Clear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles B_Clear.Click
        startzeit = DateTime.UtcNow
        T_Snif_Protokoll.Clear()
    End Sub

    Private Sub main_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
        If connected = True Then MSComm1.PortOpen = False
    End Sub

    Private Sub MSComm1_OnComm() Handles MSComm1.OnComm
        Dim Inputstr As String
        Dim bytearray() As Byte
        Dim enc As System.Text.Encoding = System.Text.Encoding.Default
        Dim timediff As TimeSpan

        Select Case MSComm1.CommEvent
            Case MSCommLib.ErrorConstants.comOverrun
                MsgBox("Overrun-Error")
            Case MSCommLib.ErrorConstants.comRxOver
                MsgBox("RxOver-Error")
            Case MSCommLib.CommEventConstants.comEventOverrun
                MsgBox("Overrun-Event")
            Case MSCommLib.CommEventConstants.comEventRxOver
                MsgBox("RxOver-Event")
            Case MSCommLib.CommEventConstants.comEventRxParity  'Ist Parity-Bit =1 wird dieser Error-Event ausgelst
                While MSComm1.InBufferCount = 0
                    'Es kann sein, dass der Parity-Event ausgelst wird bevor das zugehrige Byte im Buffer ist
                    'Erst mal warten, bis das Byte wirklich angekommen ist
                End While
                timediff = DateTime.UtcNow - startzeit  'Timestamp generieren
                Inputstr = MSComm1.Input                'Byte fr Byte einlesen
                bytearray = enc.GetBytes(Inputstr)
                DoSniffer(bytearray, True, timediff.TotalMilliseconds)
            Case MSCommLib.OnCommConstants.comEvReceive         'Ist Parity-Bit =0 wird normaler Receive-Event ausgelst
                timediff = DateTime.UtcNow - startzeit  'Timestamp generieren
                Inputstr = MSComm1.Input                'Byte fr Byte einlesen
                bytearray = enc.GetBytes(Inputstr)
                DoSniffer(bytearray, False, timediff.TotalMilliseconds)
        End Select
    End Sub

    Private Sub DoSniffer(ByVal bytes() As Byte, ByVal dir As Boolean, ByVal timestamp As Long)
        'Protokolliert die empfangenen Bytes mit entsprechendem Timestamp.
        'Es mssen immer einzelne Bytes gelsesen werden, sonst klappt das mit dem Parity nicht
        Dim n As Integer
        Dim newline As String
        Dim framelen As Byte

        If R_MFrame.Checked = True Then     'Frame-Modus: Das erste Byte wird als Formatbyte interpretiert und entsprechend Frames zusammengesetzt und protokolliert
            If firstbyte = True Then            'Empfangenes Byte ist entweder 0x00 (Wake-up-Event) oder ein Formatbyte
                If dir = True Then        'Aus erstem Byte wird die Richtung ermittelt 
                    dirstring = "Request"
                Else
                    dirstring = "Response"
                End If
                If bytes(0) = 0 Then            'Empfangenes Byte ist Wake-up-Event
                    firstbyte = True              'Nchster Byte-read bleibt 1. Byte (z.B. weiterer Wakeup oder Formatbyte
                    newline = timestamp.ToString() + ":" + "" + ":" + dirstring + ":" + "WU" + vbNewLine
                    T_Snif_Protokoll.Text = newline + T_Snif_Protokoll.Text
                Else                            'Empfangenes Byte ist Format-Byte
                    timefstart = timestamp      'Timestamp fr Framestart generieren
                    firstbyte = False           'Nchste Byte-reads sind Folgebytes im Frame
                    formatbyte = bytes(0)
                    framelen = formatbyte And &H3F      'Frame-Lnge wird im Formatbyte an den Bits 5...0 bertragen
                    framelen = framelen + 3             'Zustzlich zu den Datenbytes kommen noch 3 weitere Byte (Source-Address, Dest-Address und Checksum0 fr einen vollen Frame
                    ReDim frame(framelen - 1)
                    frameindex = 0
                End If
            Else                                'Empfangene Bytes sind Rest eines Frames
                frame(frameindex) = bytes(0)
                frameindex = frameindex + 1
                If frameindex = frame.Length Then  'Das nchste Byte ist nicht mehr Teil des aktuellen Frames
                    firstbyte = True        'Das nchste Byte wird ein neues Firstbyte sein
                    'Aktuellen Frame fertigstellen
                    newline = timefstart.ToString() + ":" + timestamp.ToString() + ":" + dirstring + ":" + formatbyte.ToString("X2")     'Framestring in Textbox erzeugen
                    For n = 0 To frame.Length - 1
                        newline = newline + "-" + frame(n).ToString("X2")
                    Next
                    newline = newline + vbNewLine
                    T_Snif_Protokoll.Text = newline + T_Snif_Protokoll.Text
                End If
            End If
        Else                    'Byte-Modus: Jedes Byte wird einzeln protokolliert ohne es zu interpretieren
            timefstart = timestamp
            If dir = True Then        'Richtung ermitteln
                dirstring = "Request"
            Else
                dirstring = "Response"
            End If
            newline = timefstart.ToString() + ":" + dirstring + ":" + bytes(0).ToString("X2") + vbNewLine
            T_Snif_Protokoll.Text = newline + T_Snif_Protokoll.Text
        End If

    End Sub

End Class