//Wartet auf fallende Flanke an zwei Inputs und liest dann an dem entsprechenden 
//Pin ein Byte mit Kline Baud-Rate 10400baud
//Byte wird dann sofort ber UART (19200 baud) an PC gesendet
//UART im 9-Bit Betrieb, 9. Bit signalisiert auf welchem Input das Byte gelesen wurde
//Zum Betrieb an dem KLine-Splitter
//--------------------------------------------------------------------------
// Connections
//  Kline-Input Request	    - RA2/Pin5
//  Kline-Input Response    - RA5/Pin2
//  UART Tx                 - TX/Pin3
//--------------------------------------------------------------------------
//
//Clock ist interner Oszillator mit 4MHz/4 = 1Mhz
//UART mit Baud-Rate 19,2kBaud, 9-Bit
//Config-register 1 sollte bei Programmierung auf 00 1001 1000 0100 (0x0984) stehen.
//Config-register 2 sollte bei Programmierung auf 01 1010 1111 1111 (0x1AFF) stehen.
		
// CONFIG1
#pragma config FOSC = INTOSC    // Oscillator Selection (INTOSC oscillator: I/O function on CLKIN pin)
#pragma config WDTE = OFF       // Watchdog Timer Enable (WDT disabled)
#pragma config PWRTE = ON       // Power-up Timer Enable (PWRT enabled)
#pragma config MCLRE = OFF      // MCLR Pin Function Select (MCLR/VPP pin function is digital input)
#pragma config CP = OFF         // Flash Program Memory Code Protection (Program memory code protection is disabled)
#pragma config CPD = OFF        // Data Memory Code Protection (Data memory code protection is disabled)
#pragma config BOREN = OFF      // Brown-out Reset Enable (Brown-out Reset disabled)
#pragma config CLKOUTEN = OFF   // Clock Out Enable (CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin)
#pragma config IESO = OFF       // Internal/External Switchover (Internal/External Switchover mode is disabled)
#pragma config FCMEN = OFF      // Fail-Safe Clock Monitor Enable (Fail-Safe Clock Monitor is disabled)

// CONFIG2
#pragma config WRT = OFF        // Flash Memory Self-Write Protection (Write protection off)
#pragma config PLLEN = OFF      // PLL Enable (4x PLL disabled)
#pragma config STVREN = ON      // Stack Overflow/Underflow Reset Enable (Stack Overflow or Underflow will cause a Reset)
#pragma config BORV = HI        // Brown-out Reset Voltage Selection (Brown-out Reset Voltage (Vbor), high trip point selected.)
#pragma config LVP = OFF        // Low-Voltage Programming Enable (High-voltage on MCLR/VPP must be used for programming)

#include <xc.h>

//Pin-Definitionen
//Pin-Outputs sollten ber das LATCH-Register erfolgen, Outputs ber PORT knnen seltsame Wirkungen zeigen
//Pin-Inputs mssen ber das PORT-Register erfolgen
#define KLineRequ       PORTAbits.RA2    //KLine-Rx Request
#define KLineResp       PORTAbits.RA5    //KLine-Rx Response

//Prototypen fr Funktionen
void KLineRecvByte(void);
void baud10400(void);
void halbbaud(void);

//Globale Variablen, die auch im Assembler-Code verwendet werden
unsigned char m; 
unsigned char n; 
unsigned char dat; 

void main(void) {
    PORTA = 0;              //Ausgnge auf Low, fr RA4 (=UART Tx) ist das der Idle-Zustand
    LATA = 0;
    TRISA = 0x2C;           //Alles Output, bis auf RA2, RA5 (K-Line-Inputs) und RA3 (Standard nut Input)
    OPTION_REG = 0xCF;      //Allgemeine Clock-Assignements
    OSCCON = 0x68;          //4 MHz ohne PLL
    APFCON = 0x06;          //Tx ist auf RA4 (Pin 3) gemappt 
    ANSELA = 0x00;          //Alles Digital-I/O, keine Analog-Ports
    SPBRGL = 12;            //Baudrate 19200 bei 4MHz, Baud = 4MHz / [16*(n+1)]
    SPBRGH = 0;
    RCSTA = 0x80;           //UART enabled, Receive disabled
    TXSTA = 0x66;           //Asynchron, 9-Bit, Transmit enabled, High baudrate mode
    BAUDCON = 0x50;         //Tx-Output invertiert, 8-Bit Baudrategenerator
    LATAbits.LATA1 = 1;     //RA1 (Pin 6) 3x toggeln, als Signal, dass MCU luft
    LATAbits.LATA1 = 0;
    LATAbits.LATA1 = 1;
    LATAbits.LATA1 = 0;
    LATAbits.LATA1 = 1;
    LATAbits.LATA1 = 0;
    while (1) {
        KLineRecvByte();
        TXREG = dat;
    }
}


//Warten auf fallende K-Line-Flanke an einem der beiden Eingnge, dann Empfang eines Datenbytes mit 10400 baud
void KLineRecvByte(void) {
    //Funktion: Wartet auf ein Startbit auf einem der beiden KLine-Inputs und liest dann ein Byte auf diesem Input nach W
    //Startbit(Low=0V), 8 Datenbits(Low=0V, High=5V) LSB first, Stopbit(High=5V) Baudrate je nach delay in baud-Routine, jeder Wechsel zwischen zwei Bits dauert 9 Zyklen + 1*baud
    while (KLineRequ==0 || KLineResp==0);   //Zuerst mssen beide Inputs=high sein um zu verhindern, dass bereits anstehendes Low (z.B. 25ms Low im Wake-up Event) gleich einen Empfang auslst
    dat = 0;
    n = 8;
    __asm("_RX0:");                          //Warte auf fallende Flanke auf einem der beiden Inputs
    __asm("          BTFSS	0x0C,2");       //Startbit (Low=0V) - fallende Flanke auf KLine-Request?
	__asm("          GOTO	_RX1");         //Ja: Byte auf Input 1 lesen
	__asm("          BTFSC	0x0C,5");       //Nein: Startbit (Low=0V) - fallende Flanke auf KLine-Response?
	__asm("          GOTO	_RX0");         //Nein: Weiter warten

    __asm("_RX2:");                          //Ja: Einlesen des Bytes auf dem Response-Input
    halbbaud();                             //Warte 1/2 baudzeit (danach gleich noch eine ganze) = 1,5 baud seit der Startbitflanke = Mitte vom ersten bit
    __asm("_RX2L:");
    baud10400();                            //Warte volle baudrate-8 Zyklen (werden in Schleife verbraten), um in naechstes Bit zu kommen
	__asm("          BTFSS   0x0C,5");      //Pruefe Bit
	__asm("          GOTO    _RX2C");        //=0V: (=Logisch 0)
	__asm("          BSF     0x03,0");       //=5V: (=Logisch 1) Carry mit 1 besetzen
	__asm("          GOTO    _RX2R");
	__asm("_RX2C:    BCF     0x03,0");       //Carry mit 0 besetzen
	__asm("          NOP");					//Damit gleich lang wie BSF-Zweig
	__asm("_RX2R:    RRF     _dat,1");       //Carry in Byte verschieben (K-Line:LSB first -> Bits werden von links nach rechts reingeschoben)
	__asm("          DECFSZ  _n,1");
	__asm("          GOTO    _RX2L");
    TXSTAbits.TX9D = 0;                     //9.Bit setzen
    __asm("          GOTO    _RXE");
    
    __asm("_RX1:");                          //Einlesen des Bytes auf dem Request-Input    
    halbbaud();                             //Warte 1/2 baudzeit (danach gleich noch eine ganze) = 1,5 baud seit der Startbitflanke = Mitte vom ersten bit
    __asm("_RX1L:");
    baud10400();                            //Warte volle baudrate-8 Zyklen (werden in Schleife verbraten), um in naechstes Bit zu kommen
	__asm("          BTFSS   0x0C,2");      //Pruefe Bit
	__asm("          GOTO    _RX1C");        //=0V: (=Logisch 0)
	__asm("          BSF     0x03,0");       //=5V: (=Logisch 1) Carry mit 1 besetzen
	__asm("          GOTO    _RX1R");
	__asm("_RX1C:    BCF     0x03,0");       //Carry mit 0 besetzen
	__asm("          NOP");					//Damit gleich lang wie BSF-Zweig
	__asm("_RX1R:    RRF     _dat,1");       //Carry in Byte verschieben (K-Line:LSB first -> Bits werden von links nach rechts reingeschoben)
	__asm("          DECFSZ  _n,1");
	__asm("          GOTO    _RX1L");
    TXSTAbits.TX9D = 1;                     //9.Bit lschen
    __asm("_RXE:     NOP");
}
    
//Warteschleife fuer Baudrate 10400
void baud10400(void) {
    //Baudrate 10400 (=96us) bei 4MHz/4 Takt (=96 Zyklen)
    //9 Zyklen werden schon in der Rx-Routine zwischen jedes Bit gesetzt d.h. zusammen mit aufrufendem CALL werden hier 87 Zyklen verbraten
    //2+2+(27*3)+1+2 (CALL + 2*MOV + 27*Schleife + RETURN)
    __asm("MOVLW  	27");	
	__asm("MOVWF  	_m");
	__asm("_a5: DECFSZ 	_m,1");			
	__asm("GOTO  	_a5");
}

//Warteschleife fuer 1/2 Baudrate 10400
void halbbaud(void) {
    //Eine halbe Baudzeit bei 10400 baud (=48us) bei 4MHz/4 Takt (=48 Zyklen)
    //2+2+(14*3)+2 (CALL + 2*MOV + 14*Schleife +  RETURN)
    __asm("MOVLW  	14");	
	__asm("MOVWF  	_m");
	__asm("_a6: DECFSZ 	_m,1");			
	__asm("GOTO  	_a6");
}
